<?php
class ControladorContratos{



	/*=============================================
	MOSTRAR CONTRATOS
	=============================================*/

	static public function ctrMostrarContratos($item, $valor){

		$tabla = "servicios";

		$respuesta = ModeloContratos::mdlMostrarContratos($tabla, $item, $valor);

		return $respuesta;

	}
	static public function ctrRecuperacion($item, $valor){

		$tabla = "general_recuperacion";

		$respuesta = ModeloContratos::mdlRecuperacionR($tabla, $item, $valor);

		return $respuesta;

	}
	static public function ctrDetalleCobRed($item, $valor){

		$tabla = "concentrado_contabilidad";

		$respuesta = ModeloContratos::mdlDetalleCobRed($tabla, $item, $valor);

		return $respuesta;

	}
	
	static public function ctrDetallePagos($item, $valor){

		$tabla = "detalle_pagos";

		$respuesta = ModeloContratos::mdlpagosR($tabla, $item, $valor);

		return $respuesta;

	}


		static public function ctrMostrarContratosVencidos($item, $valor){

		$tabla = "persona_servicio_reporte";

		$respuesta = ModeloContratos::mdlMostrarContratos($tabla, $item, $valor);

		return $respuesta;

	}


	static public function ctrMostrarContratosCodigo($item, $valor){

		$tabla = "servicios";

		$respuesta = ModeloContratos::mdlMostrarContratosCodigo($tabla, $item, $valor);

		return $respuesta;

	}


	static public function ctrMostrarContratosReporte($item, $valor){

		$tabla = "editar_servicio";

		$respuesta = ModeloContratos::mdlMostrarContratosReporte($tabla, $item, $valor);

		return $respuesta;

	}

	static public function ctrMostrarServiciosReporte($valor,$valor2,$valor3){

		$tabla = "servicio_reporte";

		$respuesta = ModeloContratos::mdlMostrarServiciosReporte($tabla, $valor,$valor2,$valor3);

		return $respuesta;

	}

	static public function ctrMostrarCobros($item, $valor){

		$tabla = "cronograma_pago";

		$respuesta = ModeloContratos::mdlMostrarCobros($tabla, $item, $valor);

		return $respuesta;

	}

	static public function ctrEliminarServicio($item, $valor){

		$tabla = "cronograma_pago";

		$respuesta = ModeloContratos::ctrComprobarServicio($tabla, $item, $valor);


		if ($respuesta == null){

			$res = ModeloContratos::mdlEliminarServicioCobros($tabla, $item, $valor);

			if ($res == "ok"){

				$res2 = ModeloContratos::mdlEliminarServicio($tabla, $item, $valor);

				if ($res2 == "ok") {

					return "ok";

				}else{
					return "error";
				}
			}


		}else {
			return "error";

		}

	}
    static public function ctrBajaServicio($item, $valor){
        $tabla = "cronograma_pago";
        
        $res = ModeloContratos::mdlBajaServicioCobros($tabla, $item, $valor);
        if ($res == "ok"){
            $res2 = ModeloContratos::mdlbajaServicio($tabla, $item, $valor);
            if ($res2 == "ok") {
                return "ok";
            }else{
                return "error";
            }
        }else{
            return "error";
        }
    }
    /* Este codigo es ACTIVAR EL CONTRATO */
        static public function ctrserviciosValida($item, $valor){
        $tabla = "cronograma_pago";
        
        $res = ModeloContratos::mdlValidaServicioCobros($tabla, $item, $valor);
        if ($res == "ok"){
            $res2 = ModeloContratos::mdlValidaServicioCro($tabla, $item, $valor);
            if ($res2 == "ok") {
                return "ok";
            }else{
                return "error";
            }
        }else{
            return "error";
        }
    }

	/* Este codigo es para mostrar todo desde vista de la base de datos */

	static public function ctrMostrarContratosCompleta($item, $valor){

		$tabla = "servicios_completo";

		$respuesta = ModeloContratos::mdlMostrarContratosCompleta($tabla, $item, $valor);

		return $respuesta;

	}

	static public function ctrEditarServicio($item, $valor){

		$tabla = "editar_servicio";

		$respuesta = ModeloContratos::mdlEditarServicio($tabla, $item, $valor);

		return $respuesta;

	}


	/*=============================================
	CREAR CONTRATOS
	=============================================*/

	static public function ctrCrearContratos(){
    date_default_timezone_set("America/Mx");
    setlocale(LC_ALL, 'spanish');
    if(isset($_POST["nuevoNombreCliente"])){
        if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoNombreCliente"]) &&
           preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoTipoServicio"])){
            
            $tabla = "servicios";
            $datos = array("codigo"=>$_POST["nuevoCodigo"],
                       "idusuario"=>$_POST["IdUsuario"],
                       "idpersona"=>$_POST["idpersona"],
                       "numromeses"=>$_POST["nuevoMeses"],
                       "direccion"=>$_POST["direccion"],
                       "fecha_instalacion"=>$_POST["fechaInstalacion"],
                       "fecha_facturacion"=>$_POST["fechaFacturacion"],
                       "idtipo_servicios"=>$_POST["idtipo_servicios"],
                       "clausula_contrato"=>$_POST["clausula_contrato"],
                       "equipos_asignados"=>$_POST["equipos_asignados"]
                      );
            
            $respuesta = ModeloContratos::mdlIngresarContratos($tabla, $datos);

            $datos2 = array(
                "idservicios" => $respuesta,
                "montos" => $_POST["montos_cronograma"],
                "fechas" => $_POST["fechas_cronograma"],
                "estado" => "0",
                "numromeses" => $_POST["nuevoMeses"]
            );

            $respuesta2 = ModeloContratos::mdlIngresarCronogramaPagos($datos2);

            if($respuesta2 == "ok"){
                echo '<script>
                    swal({
                        type: "success",
                        title: "¡El contrato ha sido guardado correctamente!",
                        showConfirmButton: true,
                        confirmButtonText: "Cerrar"
                    }).then(function(result){
                        if(result.value){
                            window.location = "contratos";
                        }
                    });
                </script>';

				}

			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡El contrato de servicio no puede ir vacío o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "contratos";

							}
						})

			  	</script>';



			}

		}

	}
	
	
    /*=============================================
	CREAR CONTRATOS DESDE VENTANA VENTAS
	=============================================*/

	static public function ctrCrearContratosV(){
    date_default_timezone_set("America/Mexico_City");
    setlocale(LC_ALL, 'spanish');
    if(isset($_POST["nuevoNombreCliente"])){
        if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoNombreCliente"]) &&
           preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoTipoServicio"])){
            
            $tabla = "servicios";
            $datos = array("codigo"=>$_POST["nuevoCodigo"],
                       "idusuario"=>$_POST["IdUsuario"],
                       "idpersona"=>$_POST["idpersona"],
                       "numromeses"=>$_POST["nuevoMeses"],
                       "direccion"=>$_POST["direccion"],
                       "fecha_instalacion"=>$_POST["fechaInstalacion"],
                       "fecha_facturacion"=>$_POST["fechaFacturacion"],
                       "idtipo_servicios"=>$_POST["idtipo_servicios"],
                       "clausula_contrato"=>$_POST["clausula_contrato"],
                       "equipos_asignados"=>$_POST["equipos_asignados"]
                      );
            
            $respuesta = ModeloContratos::mdlIngresarContratosV($tabla, $datos);

            $datos2 = array(
                "idservicios" => $respuesta,
                "montos" => $_POST["montos_cronograma"],
                "fechas" => $_POST["fechas_cronograma"],
                "estado" => "5",
                "numromeses" => $_POST["nuevoMeses"]
            );

            $respuesta2 = ModeloContratos::mdlIngresarCronogramaPagosV($datos2);

            if($respuesta2 == "ok"){
                echo '<script>
                    swal({
                        type: "success",
                        title: "¡El contrato ha sido guardado correctamente!",
                        showConfirmButton: true,
                        confirmButtonText: "Cerrar"
                    }).then(function(result){
                        if(result.value){
                            window.location = "contratos";
                        }
                    });
                </script>';

				}

			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡El contrato de servicio no puede ir vacío o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "contratos";

							}
						})

			  	</script>';



			}

		}

	}


	/*=============================================
	RANGO FECHAS
	=============================================*/

	static public function ctrRangoFechasContratos($fechaInicial, $fechaFinal){

		$tabla = "servicios";

		$respuesta = ModeloContratos::mdlFechasContratos($tabla, $fechaInicial, $fechaFinal);

		return $respuesta;

	}



	/*=============================================
	EDITAR CONTRATOS
	=============================================*/

	static public function ctrEditarContratos(){

		if(isset($_POST["nuevoNombreCliente"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoNombreCliente"]) &&
			   preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoTipoServicio"])){

			   	$tabla = "servicios";

			   	$datos = array("idservicios"=>$_POST["idservicios"],
			   				   "codigo"=>$_POST["nuevoCodigo"],
					           "idusuario"=>$_POST["IdUsuario"],
					           "idpersona"=>$_POST["idpersona"],
					           "numromeses"=>$_POST["nuevoMeses"],
							   "direccion"=>$_POST["direccion"],
							   "fecha_instalacion"=>$_POST["fechaInstalacion"],
							   "fecha_facturacion"=>$_POST["fechaFacturacion"],
					           "idtipo_servicios"=>$_POST["idtipo_servicios"]);

			   	$respuesta = ModeloContratos::mdlEditarContratos($tabla, $datos);

			   	if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "El contrato de servicio ha sido actualizado correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "personas";

									}
								})

					</script>';

				}

			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡El contrato de servicio no puede ir vacío o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "personas";

							}
						})

			  	</script>';



			}

		}

	}


	/*=============================================
	ELIMINAR CONTRATOS
	=============================================*/

	static public function ctrEliminarContrato(){

		if(isset($_GET["idservicios"])){

			$tabla ="servicios";
			$datos = $_GET["idservicios"];

			$respuesta = ModeloContratos::mdlEliminarContrato($tabla, $datos);

			if($respuesta == "ok"){

				echo'<script>

				swal({
					  type: "success",
					  title: "El cliente ha sido borrado correctamente",
					  showConfirmButton: true,
					  confirmButtonText: "Cerrar",
					  closeOnConfirm: false
					  }).then(function(result){
								if (result.value) {

								window.location = "personas";

								}
							})

				</script>';

			}

		}

	}


// controlador para contar cantidad de contratos registrados, vencidos, suspendidos y desactivados
static public function ctrcontarContratos(){
	$tabla = "servicios";
	$item = "estado";
	$totalContratos = ModeloContratos::mdlcontarContratos($tabla, null, null);
	$totalFinalizados = ModeloContratos::mdlcontarContratos($tabla, $item, 2); // contratos finalizados
	$totalActivos = ModeloContratos::mdlcontarContratos($tabla, $item, 0); //contratos activos
	$totalSuspendidos = ModeloContratos::mdlcontarContratos($tabla, $item, 1); // contratos suspendidos
	$totalDesactivados = ModeloContratos::mdlcontarContratos($tabla, $item, 3); // contratos desactivados

	$data = [
		"totalContratos" => $totalContratos,
		"totalFinalizados" => $totalFinalizados,
		"totalActivos" => $totalActivos,
		"totalSuspendidos" => $totalSuspendidos,
		"totalDesactivados" => $totalDesactivados
	];

	return json_encode($data);
}

//controlador para obtener cantidad de tipo de servicio ('Domiciliar' o 'Comercio')
//Domiciliario, Comercio
static public function ctrcontarContratosDescripcion($fecha1, $fecha2){
	//$totalDomiciliar = ModeloContratos::mdlcontarContratosDescripcion('Domiciliar',$fecha1, $fecha2);//total domiciliar
	//$totalComercial = ModeloContratos::mdlcontarContratosDescripcion('Comercio', $fecha1, $fecha2); // total comercial

	$totalDomiciliar = ModeloContratos::mdlcontarContratosDescripcion('Domiciliario',$fecha1, $fecha2);//total domiciliar
	$totalComercial = ModeloContratos::mdlcontarContratosDescripcion('Comercio', $fecha1, $fecha2); // total comercial

	$data = [
		"totalDomiciliar" => $totalDomiciliar,
		"totalComercial" => $totalComercial
	];

	return json_encode($data);
}

//controlador para obtener cobros diarios por zona (últimos 15 días)
static public function ctrObtenerCobrosDiariosPorZona(){
	try {
		$respuesta = ModeloContratos::mdlObtenerCobrosDiariosPorZona();
		return json_encode($respuesta);
	} catch (Exception $e) {
		error_log("Error en ctrObtenerCobrosDiariosPorZona: " . $e->getMessage());
		return json_encode([]);
	}
}

//controlador para obtener análisis financiero mensual
static public function ctrObtenerAnalisisMensual(){
	try {
		$respuesta = ModeloContratos::mdlObtenerAnalisisMensual();
		return json_encode($respuesta);
	} catch (Exception $e) {
		error_log("Error en ctrObtenerAnalisisMensual: " . $e->getMessage());
		return json_encode([]);
	}
}

//controlador para obtener cobros anuales por mes
static public function ctrObtenerCobrosAnualesPorMes(){
	try {
		$respuesta = ModeloContratos::mdlObtenerCobrosAnualesPorMes();
		return json_encode($respuesta);
	} catch (Exception $e) {
		error_log("Error en ctrObtenerCobrosAnualesPorMes: " . $e->getMessage());
		return json_encode([]);
	}
}

//controlador para obtener recaudación por método de pago
static public function ctrObtenerRecaudacionPorMetodoPago(){
	try {
		$respuesta = ModeloContratos::mdlObtenerRecaudacionPorMetodoPago();
		return json_encode($respuesta);
	} catch (Exception $e) {
		error_log("Error en ctrObtenerRecaudacionPorMetodoPago: " . $e->getMessage());
		return json_encode([]);
	}
}

//controlador para obtener ingresos por zona
static public function ctrObtenerIngresosPorZona(){
	try {
		$respuesta = ModeloContratos::mdlObtenerIngresosPorZona();
		return json_encode($respuesta);
	} catch (Exception $e) {
		error_log("Error en ctrObtenerIngresosPorZona: " . $e->getMessage());
		return json_encode([]);
	}
}




}
